////////////////////////////// Export Function //////////////////////////////
#pragma comment (lib, "LKBSDK.lib")	// Reference Library.
#define	LUKHAN_LIBRARY	extern "C" __declspec(dllimport)
/*
		LKB10SDK Function
*/
//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long   __stdcall
LK_GetVersion(void);
/* Return value
	 0000 XXmm	// XX : Major Version, mm : Minor Version
*/
LUKHAN_LIBRARY	long   __stdcall
LK_OpenPrinter(
				LPSTR PrinterName	// Printer name : "LKKHAN Label Printer"
				);
/* Return value
	 0	:	Success
	-2	:	Printer Open Fail
	-3	:	Can't get DEVMODE's size
	-4	:	Insufficient internal memory available
	-5	:	Can't get DEVMODE
	-6	:	Upgrade LUKHAN Label Printer Driver(V2.40 high)
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long   __stdcall
LK_ClosePrinter(void);
/* Return value
	 0	:	Success
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long   __stdcall
LK_StartPage(void);
/* Return value
	 0	:	Success
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long   __stdcall
LK_EndPage();
/* Return value
	 0	:	Success
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long   __stdcall
LK_SetupPrinter(LPSTR LabelWidth, 	// 10 ~ 104 (Unit is mm)
				LPSTR LabelLength, 	// 5 ~ 350 (Unit is mm)
				long  MediaType,	// 0=Label with Gap, 1=Label width Black Mark
				LPSTR GapHeight,	// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				LPSTR Offset,		// distance from Gap/BlackMark to perforation>. (Unit is mm)
				long  Density,		// 0 ~ 15
				long  Speed,		// 2 ~ 6 (Unit is Inch)
				long  Copies		// 1 ~ 9999
				);
/* Return value
	 0	:	Success
	-1	:	Invalid LabelWidth
	-2	:	Invalid LabelLength
	-3	:	Invalid MediaType
	-4	:	Invalid GapHeight
	-5	:	Invalid Offset
	-6	:	Invalid Density
	-7	:	Invalid Speed
	-8	:	Can't set/get DEVMODE
	-9	:	Can't make device context
	-10 :	Printer is not opened
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintWindowsFont(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	Degree,		// 0,90,180,270
				long	Height,		// TTF size (Unit is Dot)
				long	Weight,		// 0=Normal, 1=Bold
				long	Italic,		// 0=Normal, 1=Italic
				long	Underline,	// 0=Normal, 1=Underline
				LPSTR	TypeFace,	// ex> "Arial"
				LPSTR	Data		// text to be printed
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintBMP(
			long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				LPSTR	FileName	// BMP file name(incluing full path)
				);
/* Return value
	 0	:	Success
	-1	:	File open error
	-2	:	File read error
	-3	:	Not BMP file
	-4	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintPCX(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				LPSTR	FileName	// Mono PCX file name(incluing full path)
				);
/* Return value
	 0	:	Success
	-1	:	File open error
	-2	:	File read error
	-3	:	Not Mono PCX file
	-4	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintDeviceFont(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	Rotation,	// 0,90,180,270
				long	FontNumber,	// 1,2,3,4,5,8 (8=option Korean Font)
				long	HorExpand,	// 1 ~ 8
				long	VerExpand,	// 1 ~ 9
				long	Reverse,	// 0=Normal, 1=Reverse
				LPSTR	Data		// Data String
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintBarCode(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	Rotation,	// 0,90,180,270
				LPSTR	BarCode,	// type of Barcode	(Refer to LK-B10/20 Technical manual)
				long	NarrowWidth,// available 1 ~ 10 (Refer to LK-B10/20 Technical manual)
				long	WideWidth,	// available 2 ~ 30	(Refer to LK-B10/20 Technical manual)
				long	BarHeight,	// Height of Barcode (Unit is Dot)
				long	Readable,	// 0='N', 1='B'
				LPSTR	lpszStr		// Barcode content
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintLine(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	HoriSize,	// Horizontal size (Unit is Dot)
				long	VertSize	// Verticak size (Unit is Dot)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintDiagonalLine(
				long	StartX,		// Start X position (Unit is Dot)
				long	StartY,		// Start Y position (Unit is Dot)
				long	EndX,		// End X position (Unit is Dot)
				long	EndY,		// End Y position (Unit is Dot)
				long	Thick		// Line thick (Unit is Dot)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintBox(
				long	StartX,		// Start X position (Unit is Dot)
				long	StartY,		// Start Y position (Unit is Dot)
				long	EndX,		// End X position (Unit is Dot)
				long	EndY,		// End Y position (Unit is Dot)
				long	Thick		// Line thick (Unit is Dot)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintDate(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	Degree,		// 0,90,180,270
				long	Height,		// TTF size (Unit is Dot)
				long	Weight,		// 0=Normal, 1=Bold
				long	Italic,		// 0=Normal, 1=Italic
				long	Underline,	// 0=Normal, 1=Underline
				LPSTR	TypeFace,	// ex> "Arial"
				long	DateFormat	// 0=MM/DD/YY,1=DD/MM/YY,2=YY/mm/DD,3=MM/DD/YYYY,4=DD/MM/YYYY,5=YYYY/mm/DD
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintTime(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	Degree,		// 0,90,180,270
				long	Height,		// TTF size (Unit is Dot)
				long	Weight,		// 0=Normal, 1=Bold
				long	Italic,		// 0=Normal, 1=Italic
				long	Underline,	// 0=Normal, 1=Underline
				LPSTR	TypeFace,	// ex> "Arial"
				long	TimeFormat	// 0=HH:MM,1=HH:MM:SS,2=HH/MM AM(PM),3=HH/MM/SS AM(PM)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

LUKHAN_LIBRARY	long   __stdcall
LK_SetupPrinterCutter(LPSTR LabelWidth, 	// 10 ~ 104 (Unit is mm)
				LPSTR LabelLength, 	// 5~350 (Unit is mm)
				long  MediaType,	// 0=Label with Gap, 1=Label width Black Mark, 2=Label width Continuous.
				LPSTR GapHeight,	// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				LPSTR Offset,		// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				long  Density,		// 0~15
				long  Speed,		// 2~6 (Unit is Inch)
				long  Copies,		// Copy Count.
				long  Rotation,		// 180-Rotation value.
				long  Cutting,		// (0:, 1:, 2:)
				long  CutMethod,	// (0:  ,1:  ,2: 纻 ,3:۾)
				long  CutPageInterval, // 
				LPSTR FeedAfterCut
				);
/* Return value
	 0	:	Success
	-1	:	Invalid LabelWidth
	-2	:	Invalid LabelLength
	-3	:	Invalid MediaType
	-4	:	Invalid GapHeight
	-5	:	Invalid Offset
	-6	:	Invalid Density
	-7	:	Invalid Speed
	-8	:	Can't set/get DEVMODE
	-9	:	Can't make device context
	-10 :	Printer is not opened
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_DrawLine(
				long	LineType,	// Line Pen Type.
				long	sx,		// Start X position (Unit is Dot)
				long	sy,		// Start Y position (Unit is Dot)
				long	ex,	// End X position (Unit is Dot)
				long	ey,	// End Y position (Unit is Dot)
				long	Thick	// Line Thick.(Unit is Dot)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

LUKHAN_LIBRARY	long __stdcall
LK_Rectangle(
				long	LineType,	// Line Pen Type.
				long	sx,		// Start X position (Unit is Dot)
				long	sy,		// Start Y position (Unit is Dot)
				long	ex,	// End X position (Unit is Dot)
				long	ey,	// End Y position (Unit is Dot)
				long	Thick	// Line Thick.(Unit is Dot)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

LUKHAN_LIBRARY	long __stdcall
LK_Ellipse(
				long	LineType,	// Line Pen Type.
				long	sx,		// Start X position (Unit is Dot)
				long	sy,		// Start Y position (Unit is Dot)
				long	ex,	// End X position (Unit is Dot)
				long	ey,	// End Y position (Unit is Dot)
				long	Thick	// Line Thick.(Unit is Dot)
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintWindowsFontAlign(
				long	Alignment,	// Alignment(0=Left, 1=Center, 2=Right)
				long	PosY,		// Y position (Unit is Dot)
				long	Degree,		// 0,90,180,270
				long	Height,		// TTF size (Unit is Dot)
				long	Weight,		// 0=Normal, 1=Bold
				long	Italic,		// 0=Normal, 1=Italic
				long	Underline,	// 0=Normal, 1=Underline
				LPSTR	TypeFace,	// ex> "Arial"
				LPSTR	Data		// text to be printed
				);

/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintWindowsFontPitch(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				long	Degree,		// 0,90,180,270
				long	Height,		// TTF size (Unit is Dot)
				long	Width,		// TTF size (Unit is Dot)
				long	Weight,		// 0=Normal, 1=Bold
				long	Italic,		// 0=Normal, 1=Italic
				long	Underline,	// 0=Normal, 1=Underline
				LPSTR	TypeFace,	// ex> "Arial"
				LPSTR	Data		// text to be printed
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_DirectCommand(
				LPSTR	lpstr		// Command String
				);
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/

//+------------------------------------------------------------------------------------------------------------------+
LUKHAN_LIBRARY	long __stdcall
LK_PrintQRCode(
				long	PosX,		// X position (Unit is Dot)
				long	PosY,		// Y position (Unit is Dot)
				LPSTR	Data,		// Barcode Data
				long	DataSize,	// Barcode Data size
				long	ModuleSize,	// Cell Size (Unit is Dot)
				long	ECLevel,	// Error Correction Level
				long	Version,		// Version
				long	MaskPattern	// Mask Pattern
				)
//+------------------------------------------------------------------------------------------------------------------+
				
/* Return value
	 0	:	Success
	-1	:	Can't create Font
	-2	:	SetupPrinter() is not called
*/
